"use strict";
exports.id = 3850;
exports.ids = [3850];
exports.modules = {

/***/ 31631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/delete-icon.7460c87d.png","height":18,"width":18,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAqklEQVR42k3PMQrCQBCF4ek01xBbsddOougGQeIknYjYBMFCQbBQ8QBWGiwFC80NBC+SKwgeYvBvJFn4mBnmLcvK/5iLNsjM6QPbYhFog4WPnMWRCs3hWxA1hUDC8MWBfoc9IegHS7F+WKVJbaA1agdd1HG23rBCIPYYrubGc+qJ29AZUnOhJ8Ix0phijRUmuJR+oHduLnimjRZzgls5EONN6ImM/oWRiMgPwm5vDXlWm10AAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 59614:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/Group 1597886316.6d8a16a7.svg","height":56,"width":77});

/***/ }),

/***/ 29529:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/mapMarker.0e641af6.png","height":1004,"width":1004,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAv0lEQVR42mP43xbIxAAE/2YUc/zLYsgG4sx/c6vZwWLtQYwMMPC/2XPvv20L///bMv//v2aPXQzI4F8yg+2/ZV3/geDXPxBe0v4fKGaBUJDPoPpveuH//+9f///39uX/f1Pz/v8rYFCCSNZZM4PpevvKf93R//91R/0HskugYmA5hn95DGCH/u8InQPEM8BiJTxMEMmuCDDjX2eEG9CEAiAuBLJd4HKfe9PBXvnWkyz+vi/bEoSBbDGgEFAujREAJnpnt5/lJNAAAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 87207:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/editIcon.95a0ff40.png","height":64,"width":64,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAm0lEQVR42k2OMQ7CMAxFKTML5wDEiMTERiUGxNahA0sRHVjKAThDnQuQrGBfEV5IiRrpKY7/948n8bjwLpzXk/N2iKT6VURtMGhFs3fBmohQQ50NEuyGYUHzGKe5V1CNE64IGyjFWylPnWG4M7j+J7TyM1gtaQ+BD3RDgl14bEmYwyOJ2ucvmO5gB40EzeLYsIQWcc99zrt5nX4BhAprliGtFpQAAAAASUVORK5CYII=","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 74453:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ useDeleteAddress)
/* harmony export */ });
/* harmony import */ var _MainApi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61176);
/* harmony import */ var _ApiRoutes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60274);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61175);
/* harmony import */ var react_query__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_query__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_MainApi__WEBPACK_IMPORTED_MODULE_0__]);
_MainApi__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



const deleteData = async (addressId)=>{
    const { data  } = await _MainApi__WEBPACK_IMPORTED_MODULE_0__/* ["default"]["delete"] */ .Z["delete"](`${_ApiRoutes__WEBPACK_IMPORTED_MODULE_2__/* .delete_address_api */ .fb}?address_id=${addressId}`);
    return data;
};
function useDeleteAddress() {
    return (0,react_query__WEBPACK_IMPORTED_MODULE_1__.useMutation)("delete-address", deleteData);
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 93220:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(57987);
/* harmony import */ var _api_manage_hooks_react_query_address_useDeleteAddress__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74453);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86390);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(45269);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86201);
/* harmony import */ var _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67759);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(76829);
/* harmony import */ var _mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _assets_mapMarker_png__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(29529);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_3__, _api_manage_hooks_react_query_address_useDeleteAddress__WEBPACK_IMPORTED_MODULE_4__, react_hot_toast__WEBPACK_IMPORTED_MODULE_7__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_3__, _api_manage_hooks_react_query_address_useDeleteAddress__WEBPACK_IMPORTED_MODULE_4__, react_hot_toast__WEBPACK_IMPORTED_MODULE_7__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);











const DeleteAddress = ({ open , handleClose , addressId , refetch  })=>{
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
    const { mutate: deleteMutation , isLoading , error  } = (0,_api_manage_hooks_react_query_address_useDeleteAddress__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)();
    const deleteAddress = ()=>{
        deleteMutation(addressId, {
            onSuccess: ()=>{
                react_hot_toast__WEBPACK_IMPORTED_MODULE_7__["default"].success(t("Address deleted successfully."));
                refetch?.();
                handleClose?.();
            },
            onError: _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_8__/* .onSingleErrorResponse */ .f$
        });
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
            openModal: open,
            handleClose: handleClose,
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Paper, {
                sx: {
                    textAlign: "center",
                    padding: "2rem"
                },
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_6__/* .CustomStackFullWidth */ .Xw, {
                    alignItems: "center",
                    justifyContent: "center",
                    spacing: 3,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                            src: _assets_mapMarker_png__WEBPACK_IMPORTED_MODULE_10__/* ["default"].src */ .Z.src,
                            alt: t("map-image"),
                            width: "60px",
                            height: "60px"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            fontWeight: "bold",
                            variant: "h6",
                            children: t("Are you sure you want to delete this address?")
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_6__/* .CustomStackFullWidth */ .Xw, {
                            direction: "row",
                            alignItems: "center",
                            justifyContent: "center",
                            spacing: 2,
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Button, {
                                    sx: {
                                        backgroundColor: (theme)=>theme.palette.neutral[300],
                                        color: (theme)=>theme.palette.neutral[1000],
                                        width: "120px",
                                        "&:hover": {
                                            backgroundColor: (theme)=>theme.palette.neutral[400]
                                        }
                                    },
                                    onClick: handleClose,
                                    children: t("Cancel")
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_lab_LoadingButton__WEBPACK_IMPORTED_MODULE_9___default()), {
                                    loading: isLoading,
                                    sx: {
                                        background: (theme)=>theme.palette.error.light,
                                        color: "white",
                                        width: "120px",
                                        "&:hover": {
                                            backgroundColor: (theme)=>theme.palette.error.dark
                                        }
                                    },
                                    onClick: ()=>deleteAddress(),
                                    children: t("Delete")
                                })
                            ]
                        })
                    ]
                })
            })
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeleteAddress);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 59308:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);





const Shimmer = ()=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomBoxFullWidth */ .uu, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
            container: true,
            spacing: 3,
            children: [
                ...Array(2)
            ].map((item, index)=>{
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Grid, {
                    item: true,
                    xs: 12,
                    sm: 6,
                    md: 6,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Skeleton, {
                        variant: "rectangular",
                        width: "100%",
                        height: "10rem"
                    })
                }, index);
            })
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Shimmer);


/***/ }),

/***/ 84279:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export AddAddressSearchBox */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_icons_material_ArrowBackIosNew__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95780);
/* harmony import */ var _mui_icons_material_ArrowBackIosNew__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_ArrowBackIosNew__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _profile_basic_information_BasicInformationForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33010);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22021);
/* harmony import */ var _states__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(87668);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11022);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_geolocated__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _api_manage_hooks_react_query_google_api_usePlaceAutoComplete__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52073);
/* harmony import */ var _api_manage_hooks_react_query_google_api_useGetGeoCode__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3586);
/* harmony import */ var _api_manage_hooks_react_query_google_api_useGetZone__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(55496);
/* harmony import */ var _api_manage_hooks_react_query_google_api_useGetPlaceDetails__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99895);
/* harmony import */ var _Map_GoogleMapComponent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(12411);
/* harmony import */ var _Map_CustomMapSearch__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(69893);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _HelperFunctions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(10724);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(45269);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(58861);
/* harmony import */ var _checkout_assets_image_1256_png__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(42489);
/* harmony import */ var _assets_office_png__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(39233);
/* harmony import */ var _assets_plus_png__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(78198);
/* harmony import */ var _AddressForm__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(27193);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(15594);
/* harmony import */ var _mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_24__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_profile_basic_information_BasicInformationForm__WEBPACK_IMPORTED_MODULE_4__, i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_google_api_usePlaceAutoComplete__WEBPACK_IMPORTED_MODULE_8__, _api_manage_hooks_react_query_google_api_useGetGeoCode__WEBPACK_IMPORTED_MODULE_9__, _api_manage_hooks_react_query_google_api_useGetZone__WEBPACK_IMPORTED_MODULE_10__, _api_manage_hooks_react_query_google_api_useGetPlaceDetails__WEBPACK_IMPORTED_MODULE_11__, _Map_CustomMapSearch__WEBPACK_IMPORTED_MODULE_13__, _AddressForm__WEBPACK_IMPORTED_MODULE_21__]);
([_profile_basic_information_BasicInformationForm__WEBPACK_IMPORTED_MODULE_4__, i18next__WEBPACK_IMPORTED_MODULE_5__, _api_manage_hooks_react_query_google_api_usePlaceAutoComplete__WEBPACK_IMPORTED_MODULE_8__, _api_manage_hooks_react_query_google_api_useGetGeoCode__WEBPACK_IMPORTED_MODULE_9__, _api_manage_hooks_react_query_google_api_useGetZone__WEBPACK_IMPORTED_MODULE_10__, _api_manage_hooks_react_query_google_api_useGetPlaceDetails__WEBPACK_IMPORTED_MODULE_11__, _Map_CustomMapSearch__WEBPACK_IMPORTED_MODULE_13__, _AddressForm__WEBPACK_IMPORTED_MODULE_21__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

























const AddAddressSearchBox = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_22__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_14__.Box)(({ theme  })=>({
        position: "absolute",
        zIndex: "999",
        width: "85%",
        top: "10%",
        marginLeft: "20px",
        [theme.breakpoints.down("md")]: {
            marginLeft: "13px"
        }
    }));
const AddAddressComponent = ({ setAddAddress , editAddress , userData , addressRefetch , setEditAddress  })=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const [state, dispatch] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useReducer)(_states__WEBPACK_IMPORTED_MODULE_6__/* .reducer */ .I6, _states__WEBPACK_IMPORTED_MODULE_6__/* .initialState */ .E3);
    const [addressType, setAddressType] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(editAddress ? editAddress?.address_type : "");
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_23__.useSelector)((state)=>state.configData);
    const [isDisablePickButton, setDisablePickButton] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [locationEnabled, setLocationEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [location, setLocation] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(configData && configData?.default_location);
    const [searchKey, setSearchKey] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const [enabled, setEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [placeDetailsEnabled, setPlaceDetailsEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
    const [placeDescription, setPlaceDescription] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(undefined);
    const [predictions, setPredictions] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [placeId, setPlaceId] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    //****getting current location/***/
    const { coords , isGeolocationAvailable , isGeolocationEnabled , getPosition  } = (0,react_geolocated__WEBPACK_IMPORTED_MODULE_7__.useGeolocated)({
        positionOptions: {
            enableHighAccuracy: false
        },
        userDecisionTimeout: 5000,
        isGeolocationEnabled: true
    });
    const { data: places , isLoading  } = (0,_api_manage_hooks_react_query_google_api_usePlaceAutoComplete__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)(searchKey, enabled);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (places) {
            setPredictions(places?.predictions);
        }
    }, [
        places
    ]);
    const zoneIdEnabled = locationEnabled;
    const { data: zoneData  } = (0,_api_manage_hooks_react_query_google_api_useGetZone__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z)(location, zoneIdEnabled);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (false) {}
    }, [
        zoneData
    ]);
    const { isLoading: isLoading2 , data: placeDetails  } = (0,_api_manage_hooks_react_query_google_api_useGetPlaceDetails__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)(placeId, placeDetailsEnabled);
    //
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (placeDetails) {
            setLocation(placeDetails?.result?.geometry?.location);
            setLocationEnabled(true);
        }
    }, [
        placeDetails
    ]);
    const { data: geoCodeResults , isFetching: isFetchingGeoCode  } = (0,_api_manage_hooks_react_query_google_api_useGetGeoCode__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z)(location);
    const handleClick = (name)=>{
        setAddressType(name);
        setEditAddress({
            ...editAddress,
            address_type: null
        });
    };
    const handleChangeForSearchs = (event)=>{
        if (event.target.value) {
            setSearchKey(event.target.value);
            setEnabled(true);
            setPlaceDetailsEnabled(true);
        }
    };
    const handleChangeS = (event, value)=>{
        if (value) {
            setPlaceId(value?.place_id);
        }
        setPlaceDetailsEnabled(true);
    };
    const getCurrentLocation = ()=>{
        setLocation({
            lat: coords.latitude,
            lng: coords.longitude
        });
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Grid, {
                item: true,
                md: 12,
                xs: 12,
                alignSelf: "center",
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                    direction: "row",
                    justifyContent: "space-between",
                    alignItems: "center",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: "subtitle2",
                            fontWeight: "700",
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Add Address")
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_profile_basic_information_BasicInformationForm__WEBPACK_IMPORTED_MODULE_4__/* .BackIconButton */ .dc, {
                            onClick: ()=>setAddAddress(false),
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_ArrowBackIosNew__WEBPACK_IMPORTED_MODULE_3___default()), {
                                    sx: {
                                        fontSize: "10px",
                                        color: (theme)=>theme.palette.primary.main,
                                        fontWeight: "700",
                                        marginRight: "3px"
                                    }
                                }),
                                (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Go Back")
                            ]
                        })
                    ]
                })
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Grid, {
                item: true,
                xs: 12,
                md: 5,
                position: "relative",
                align: "center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddAddressSearchBox, {
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Map_CustomMapSearch__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                            predictions: predictions,
                            handleChange: (event, value)=>handleChangeS(event, value, dispatch),
                            HandleChangeForSearch: (event)=>handleChangeForSearchs(event, dispatch),
                            handleAgreeLocation: ()=>(0,_HelperFunctions__WEBPACK_IMPORTED_MODULE_15__/* .handleAgreeLocation */ .Bm)(coords, dispatch),
                            currentLocation: state.currentLocation,
                            handleCloseLocation: ()=>(0,_HelperFunctions__WEBPACK_IMPORTED_MODULE_15__/* .handleCloseLocation */ .c$)(dispatch)
                        })
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                        children: [
                            location && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Map_GoogleMapComponent__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
                                setLocation: setLocation,
                                location: location,
                                setPlaceDetailsEnabled: setPlaceDetailsEnabled,
                                placeDetailsEnabled: placeDetailsEnabled,
                                locationEnabled: locationEnabled,
                                setPlaceDescription: setPlaceDescription,
                                setLocationEnabled: setLocationEnabled,
                                setDisablePickButton: setDisablePickButton,
                                height: "350px"
                            }),
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.IconButton, {
                                onClick: getCurrentLocation,
                                sx: {
                                    position: "absolute",
                                    bottom: "25%",
                                    right: "10px",
                                    borderRadius: "50%",
                                    color: (theme)=>theme.palette.primary.main,
                                    backgroundColor: "background.paper"
                                },
                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_GpsFixed__WEBPACK_IMPORTED_MODULE_24___default()), {
                                    sx: {
                                        fontSize: {
                                            xs: "18px",
                                            md: "24px"
                                        }
                                    }
                                })
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Grid, {
                item: true,
                xs: 12,
                md: 7,
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_16__/* .CustomStackFullWidth */ .Xw, {
                        mb: "20px",
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                children: (0,i18next__WEBPACK_IMPORTED_MODULE_5__.t)("Label As")
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Stack, {
                                direction: "row",
                                spacing: 2.5,
                                pt: "10px",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_16__/* .AddressTypeStack */ .Bh, {
                                        value: "home",
                                        addressType: editAddress?.address_type ? editAddress?.address_type : addressType,
                                        onClick: ()=>handleClick("home"),
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                            src: _checkout_assets_image_1256_png__WEBPACK_IMPORTED_MODULE_18__/* ["default"].src */ .Z.src,
                                            width: "24px",
                                            height: "24px"
                                        })
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_16__/* .AddressTypeStack */ .Bh, {
                                        value: "office",
                                        addressType: editAddress?.address_type ? editAddress?.address_type : addressType,
                                        onClick: ()=>handleClick("office"),
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                            src: _assets_office_png__WEBPACK_IMPORTED_MODULE_19__/* ["default"].src */ .Z.src,
                                            width: "24px",
                                            height: "24px"
                                        })
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_16__/* .AddressTypeStack */ .Bh, {
                                        value: "other",
                                        addressType: editAddress?.address_type ? editAddress?.address_type : addressType,
                                        onClick: ()=>handleClick("other"),
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                            src: _assets_plus_png__WEBPACK_IMPORTED_MODULE_20__/* ["default"].src */ .Z.src,
                                            width: "24px",
                                            height: "24px"
                                        })
                                    })
                                ]
                            })
                        ]
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AddressForm__WEBPACK_IMPORTED_MODULE_21__/* ["default"] */ .Z, {
                        deliveryAddress: geoCodeResults?.results[0]?.formatted_address,
                        atModal: "false",
                        addressType: addressType,
                        configData: configData,
                        phone: editAddress ? editAddress?.phone : userData?.phone,
                        email: editAddress ? editAddress?.email : userData?.email,
                        lat: location?.lat || "",
                        lng: location?.lng || "",
                        personName: editAddress ? editAddress?.contact_person_name : userData && `${userData?.f_name} ${userData?.l_name}`,
                        editAddress: editAddress,
                        setAddAddress: setAddAddress,
                        refetch: addressRefetch
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddAddressComponent);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 74847:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export AddressTypography */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45269);
/* harmony import */ var _mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(72625);
/* harmony import */ var _mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _CustomDivider__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(35740);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67934);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _public_static_delete_icon_png__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31631);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(57987);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(86390);
/* harmony import */ var _DeleteAddress__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(93220);
/* harmony import */ var _svg_AddressEditSvg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(98206);
/* harmony import */ var _redux_slices_addAddress__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(27437);
/* harmony import */ var _add_new_address__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(89728);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(22021);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_9__, _DeleteAddress__WEBPACK_IMPORTED_MODULE_11__, _add_new_address__WEBPACK_IMPORTED_MODULE_14__, i18next__WEBPACK_IMPORTED_MODULE_15__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_9__, _DeleteAddress__WEBPACK_IMPORTED_MODULE_11__, _add_new_address__WEBPACK_IMPORTED_MODULE_14__, i18next__WEBPACK_IMPORTED_MODULE_15__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

















const AddressTypography = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography)(({ theme , fontWeight  })=>({
        fontWeight: fontWeight ? fontWeight : "500",
        fontSize: "12px"
    }));
const AddressCard = (props)=>{
    const { item , refetch , dispatch , configData , edit , setEditAddress , setAddAddress  } = props;
    const { address_type , contact_person_number , address , road , floor , house , latitude , longitude , user_id , contact_person_name , zone_id , id  } = item;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_9__.useTranslation)();
    const [openDelete, setOpenDelete] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const { openAddressModal  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_16__.useSelector)((state)=>state.addressModel);
    const handleClick = ()=>{
        setEditAddress(item);
        setAddAddress((prevState)=>!prevState);
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__/* .CustomPaperBigCard */ .iD, {
        padding: "0px",
        sx: {
            borderRadius: "5px",
            boxShadow: "0px 9.075414657592773px 18.150829315185547px -2.7226247787475586px rgba(145, 158, 171, 0.05), 0px 0px 1.8150832653045654px 0px rgba(145, 158, 171, 0.20)"
        },
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__/* .CustomStackFullWidth */ .Xw, {
                spacing: 2,
                children: [
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__/* .CustomStackFullWidth */ .Xw, {
                        direction: "row",
                        alignItems: "center",
                        justifyContent: "space-between",
                        padding: {
                            xs: " 4px 20px",
                            md: " 13px 20px"
                        },
                        sx: {
                            background: (theme)=>(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.info.contrastText1, 0.3),
                            borderRadius: "5px 5px 0px 0px"
                        },
                        children: [
                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                fontWeight: "500",
                                textTransform: "capitalize",
                                children: t(address_type)
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                                direction: "row",
                                alignItems: "center",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_7___default()), {
                                        onClick: handleClick,
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_svg_AddressEditSvg__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {})
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_7___default()), {
                                        onClick: ()=>setOpenDelete(true),
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                                            src: _public_static_delete_icon_png__WEBPACK_IMPORTED_MODULE_8__/* ["default"].src */ .Z.src,
                                            alt: "delete"
                                        })
                                    })
                                ]
                            })
                        ]
                    }),
                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                        padding: "0px 20px 23px 20px",
                        spacing: 1,
                        children: [
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                                direction: "row",
                                gap: "30px",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddressTypography, {
                                        children: t("Name")
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddressTypography, {
                                        fontWeight: "400",
                                        children: contact_person_name
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                                direction: "row",
                                gap: "25px",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddressTypography, {
                                        children: t("Phone")
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddressTypography, {
                                        fontWeight: "400",
                                        children: contact_person_number
                                    })
                                ]
                            }),
                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                                direction: "row",
                                gap: "15px",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AddressTypography, {
                                        children: t("Address")
                                    }),
                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(AddressTypography, {
                                        fontWeight: "400",
                                        children: [
                                            " ",
                                            address
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                ]
            }),
            openDelete && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_DeleteAddress__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                open: openDelete,
                handleClose: ()=>setOpenDelete(false),
                addressId: id,
                refetch: refetch
            })
        ]
    });
};
AddressCard.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddressCard);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 73850:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "N": () => (/* binding */ GrayButton),
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72625);
/* harmony import */ var _mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _custom_empty_result__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58797);
/* harmony import */ var _assets_Group_1597886316_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(59614);
/* harmony import */ var _Shimmer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59308);
/* harmony import */ var _address_card__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(74847);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(22021);
/* harmony import */ var _profile_basic_information__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(44969);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var redux_slices_storedData__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(8697);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_custom_empty_result__WEBPACK_IMPORTED_MODULE_6__, _address_card__WEBPACK_IMPORTED_MODULE_9__, i18next__WEBPACK_IMPORTED_MODULE_11__, _profile_basic_information__WEBPACK_IMPORTED_MODULE_12__]);
([_custom_empty_result__WEBPACK_IMPORTED_MODULE_6__, _address_card__WEBPACK_IMPORTED_MODULE_9__, i18next__WEBPACK_IMPORTED_MODULE_11__, _profile_basic_information__WEBPACK_IMPORTED_MODULE_12__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const GrayButton = (0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Button)(({ theme  })=>({
        color: theme.palette.neutral[400],
        fontSize: "12px",
        border: "1px solid",
        borderColor: theme.palette.neutral[400],
        borderRadius: "5px"
    }));
const Address = (props)=>{
    const { configData , setAddAddress , addAddress , setEditAddress , data , refetch , isLoading  } = props;
    const { AllSaveAddress  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.storedData);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useDispatch)();
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_13__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.useMediaQuery)(theme.breakpoints.down("md"));
    const { openAddressModal  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.addressModel);
    const [edit, setEdit] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (AllSaveAddress?.length === 0) {
            refetch();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (data) {
            dispatch((0,redux_slices_storedData__WEBPACK_IMPORTED_MODULE_14__/* .setAllSaveAddress */ .eP)(data?.addresses));
        }
    }, [
        data
    ]);
    const handleClick = ()=>{
        setEditAddress(null);
        setAddAddress((prvState)=>!prvState);
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__/* .CustomStackFullWidth */ .Xw, {
        padding: {
            xs: "10px",
            sm: "15px",
            md: "20px"
        },
        spacing: 2,
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__/* .CustomStackFullWidth */ .Xw, {
                justifyContent: "space-between",
                direction: "row",
                alignItems: "center",
                children: [
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                        fontSize: {
                            xs: "14px",
                            sm: "14px",
                            md: "16px"
                        },
                        fontWeight: "700",
                        children: (0,i18next__WEBPACK_IMPORTED_MODULE_11__.t)("My Addresses")
                    }),
                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                        children: isSmall ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_profile_basic_information__WEBPACK_IMPORTED_MODULE_12__/* .SmallDeviceIconButton */ .x, {
                            onClick: handleClick,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_2___default()), {
                                style: {
                                    fontSize: "16px"
                                }
                            })
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(GrayButton, {
                            onClick: handleClick,
                            variant: "outlined",
                            startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_LocationOn__WEBPACK_IMPORTED_MODULE_2___default()), {
                                style: {
                                    fontSize: "16px"
                                }
                            }),
                            children: (0,i18next__WEBPACK_IMPORTED_MODULE_11__.t)("Add Address")
                        })
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                container: true,
                spacing: {
                    xs: 1,
                    sm: 1.5,
                    md: 2.5
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                    item: true,
                    xs: 12,
                    md: 12,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.NoSsr, {
                        children: isLoading ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Shimmer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {}) : AllSaveAddress && AllSaveAddress?.length > 0 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Box, {
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                                container: true,
                                children: AllSaveAddress?.map((item, index)=>{
                                    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                                        item: true,
                                        xs: 12,
                                        sm: 6,
                                        md: 6,
                                        lg: 6,
                                        paddingRight: {
                                            xs: "10px",
                                            sm: "15px",
                                            md: "25px"
                                        },
                                        paddingBottom: {
                                            xs: "10px",
                                            sm: "15px",
                                            md: "25px"
                                        },
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_address_card__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
                                            item: item,
                                            refetch: refetch,
                                            configData: configData,
                                            dispatch: dispatch,
                                            openAddressModal: openAddressModal,
                                            setEditAddress: setEditAddress,
                                            edit: edit,
                                            setAddAddress: setAddAddress
                                        })
                                    }, item.id);
                                })
                            })
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_5__.Stack, {
                            alignItems: "center",
                            justifyContent: "center",
                            width: "100%",
                            height: "100%",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_custom_empty_result__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                                label: "No address found",
                                image: _assets_Group_1597886316_svg__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z,
                                width: "128px",
                                height: "80"
                            })
                        })
                    })
                })
            })
        ]
    });
};
Address.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Address);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 98206:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);



const AddressEditSvg = ()=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("svg", {
        width: "21",
        height: "20",
        viewBox: "0 0 21 20",
        fill: "none",
        xmlns: "http://www.w3.org/2000/svg",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("path", {
            d: "M9.22685 9.16536H10.9883L16.1886 3.9987L14.4272 2.2487L9.22685 7.41536V9.16536ZM16.7758 3.41536L17.3629 2.83203C17.5307 2.66536 17.6145 2.47092 17.6145 2.2487C17.6145 2.02648 17.5307 1.83203 17.3629 1.66536L16.7758 1.08203C16.608 0.915365 16.4123 0.832031 16.1886 0.832031C15.9649 0.832031 15.7692 0.915365 15.6015 1.08203L15.0143 1.66536L16.7758 3.41536ZM10.0656 18.332C7.81492 16.4293 6.13403 14.6618 5.02294 13.0295C3.91129 11.3979 3.35547 9.88759 3.35547 8.4987C3.35547 6.41536 4.03012 4.75564 5.37942 3.51953C6.72816 2.28342 8.29022 1.66536 10.0656 1.66536C10.4431 1.66536 10.8172 1.69648 11.1879 1.7587C11.5581 1.82148 11.9179 1.90842 12.2674 2.01953L10.9044 3.39453C10.7646 3.36675 10.6281 3.34925 10.4951 3.34203C10.3625 3.33536 10.2194 3.33203 10.0656 3.33203C8.65369 3.33203 7.4618 3.81453 6.48995 4.77953C5.51865 5.74509 5.033 6.98481 5.033 8.4987C5.033 9.48481 5.4454 10.6131 6.27019 11.8837C7.09498 13.1548 8.36012 14.5681 10.0656 16.1237C11.7711 14.5681 13.0363 13.1548 13.861 11.8837C14.6858 10.6131 15.0982 9.48481 15.0982 8.4987C15.0982 8.33203 15.0912 8.1687 15.0773 8.0087C15.0633 7.84925 15.0423 7.69314 15.0143 7.54036L16.3983 6.16536C16.5241 6.52648 16.6186 6.90148 16.6818 7.29036C16.7444 7.67925 16.7758 8.08203 16.7758 8.4987C16.7758 9.88759 16.2202 11.3979 15.1091 13.0295C13.9975 14.6618 12.3163 16.4293 10.0656 18.332Z",
            fill: theme.palette.primary.main
        })
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddressEditSvg);


/***/ }),

/***/ 68385:
/***/ ((module, __unused_webpack___webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Profile_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83705);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_icons_material_Visibility__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(50773);
/* harmony import */ var _mui_icons_material_Visibility__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Visibility__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_icons_material_VisibilityOff__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77749);
/* harmony import */ var _mui_icons_material_VisibilityOff__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_VisibilityOff__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(57987);
/* harmony import */ var _Validation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38323);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(33103);
/* harmony import */ var _mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_mui_material_InputAdornment__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(67934);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(47915);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _typographies_H1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(74485);
/* harmony import */ var _api_manage_hooks_react_query_profile_useUpdateProfile__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(92522);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(86201);
/* harmony import */ var _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(67759);
/* harmony import */ var _BasicInformationForm__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(33010);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_7__, _Validation__WEBPACK_IMPORTED_MODULE_8__, _typographies_H1__WEBPACK_IMPORTED_MODULE_14__, _api_manage_hooks_react_query_profile_useUpdateProfile__WEBPACK_IMPORTED_MODULE_15__, react_hot_toast__WEBPACK_IMPORTED_MODULE_16__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_17__, _BasicInformationForm__WEBPACK_IMPORTED_MODULE_18__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_7__, _Validation__WEBPACK_IMPORTED_MODULE_8__, _typographies_H1__WEBPACK_IMPORTED_MODULE_14__, _api_manage_hooks_react_query_profile_useUpdateProfile__WEBPACK_IMPORTED_MODULE_15__, react_hot_toast__WEBPACK_IMPORTED_MODULE_16__, _api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_17__, _BasicInformationForm__WEBPACK_IMPORTED_MODULE_18__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



















const AccountInformation = ({ data , refetch  })=>{
    const { t  } = useTranslation();
    const theme = useTheme();
    const [showPassword, setShowPassword] = useState(false);
    const [showConfirmPassword, setConfirmShowPassword] = useState(false);
    const { f_name , l_name , phone , email  } = data;
    const profileFormik = useFormik({
        initialValues: {
            f_name: f_name ? f_name : "",
            l_name: l_name ? l_name : "",
            email: email ? email : "",
            phone: phone ? phone : "",
            password: "",
            confirm_password: ""
        },
        validationSchema: Yup.object({
            password: Yup.string().required(t("No password provided.")).min(6, t("Password is too short - should be 6 chars minimum.")),
            confirm_password: Yup.string().required(t("Confirm Password")).oneOf([
                Yup.ref("password"),
                null
            ], t("Passwords must match"))
        }),
        onSubmit: async (values, helpers)=>{
            try {
                formSubmitOnSuccess(values);
            } catch (err) {}
        }
    });
    const { mutate: profileUpdateByMutate , isLoading  } = useUpdateProfile();
    const formSubmitOnSuccess = (values)=>{
        const onSuccessHandler = (response)=>{
            if (response) {
                toast.success(response?.message);
                refetch();
            }
        };
        const formData = convertValuesToFormData(values);
        profileUpdateByMutate(formData, {
            onSuccess: onSuccessHandler,
            onError: onSingleErrorResponse
        });
    };
    return /*#__PURE__*/ _jsx(_Fragment, {
        children: /*#__PURE__*/ _jsx("form", {
            noValidate: true,
            onSubmit: profileFormik.handleSubmit,
            children: /*#__PURE__*/ _jsxs(Grid, {
                container: true,
                md: 12,
                xs: 12,
                spacing: 2,
                sx: {
                    padding: "20px"
                },
                children: [
                    /*#__PURE__*/ _jsx(Grid, {
                        item: true,
                        md: 12,
                        xs: 12,
                        textAlign: "center",
                        children: /*#__PURE__*/ _jsx(H1, {
                            text: "Account Information"
                        })
                    }),
                    /*#__PURE__*/ _jsx(Grid, {
                        item: true,
                        md: 6,
                        xs: 12,
                        children: /*#__PURE__*/ _jsx(TextField, {
                            required: true,
                            sx: {
                                width: "100%"
                            },
                            id: "password",
                            variant: "outlined",
                            value: profileFormik.values.password,
                            onChange: profileFormik.handleChange,
                            name: "password",
                            label: t("Password"),
                            type: showPassword ? "text" : "password",
                            InputLabelProps: {
                                shrink: true
                            },
                            error: profileFormik.touched.password && Boolean(profileFormik.errors.password),
                            helperText: profileFormik.touched.password && profileFormik.errors.password,
                            InputProps: {
                                endAdornment: /*#__PURE__*/ _jsx(InputAdornment, {
                                    position: "end",
                                    children: /*#__PURE__*/ _jsx(IconButton, {
                                        "aria-label": "toggle password visibility",
                                        onClick: ()=>setShowPassword((prevState)=>!prevState),
                                        edge: "end",
                                        children: showPassword ? /*#__PURE__*/ _jsx(Visibility, {}) : /*#__PURE__*/ _jsx(VisibilityOff, {})
                                    })
                                })
                            }
                        })
                    }),
                    /*#__PURE__*/ _jsx(Grid, {
                        item: true,
                        md: 6,
                        xs: 12,
                        children: /*#__PURE__*/ _jsx(TextField, {
                            required: true,
                            sx: {
                                width: "100%"
                            },
                            id: "confirm_password",
                            label: t("Confirm Password"),
                            variant: "outlined",
                            name: "confirm_password",
                            type: showConfirmPassword ? "text" : "password",
                            value: profileFormik.values.confirm_password,
                            onChange: profileFormik.handleChange,
                            InputLabelProps: {
                                shrink: true
                            },
                            error: profileFormik.touched.confirm_password && Boolean(profileFormik.errors.confirm_password),
                            helperText: profileFormik.touched.confirm_password && profileFormik.errors.confirm_password,
                            touched: profileFormik.touched.confirm_password && "true",
                            InputProps: {
                                endAdornment: /*#__PURE__*/ _jsx(InputAdornment, {
                                    position: "end",
                                    children: /*#__PURE__*/ _jsx(IconButton, {
                                        "aria-label": "toggle password visibility",
                                        onClick: ()=>setConfirmShowPassword((prevState)=>!prevState),
                                        edge: "end",
                                        children: showConfirmPassword ? /*#__PURE__*/ _jsx(Visibility, {}) : /*#__PURE__*/ _jsx(VisibilityOff, {})
                                    })
                                })
                            }
                        })
                    }),
                    /*#__PURE__*/ _jsx(Grid, {
                        item: true,
                        xs: 12,
                        md: 12,
                        align: "end",
                        children: /*#__PURE__*/ _jsx(SaveButton, {
                            variant: "contained",
                            type: "submit",
                            loading: isLoading,
                            children: t(" Change")
                        })
                    })
                ]
            })
        })
    });
};
/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ((/* unused pure expression or super */ null && (AccountInformation)));

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 44969:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "x": () => (/* binding */ SmallDeviceIconButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45269);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _BasicInformationForm__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33010);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67294);
/* harmony import */ var _AccountInformation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(68385);
/* harmony import */ var _mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1664);
/* harmony import */ var _mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Edit__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _redux_slices_addAddress__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27437);
/* harmony import */ var _address_add_new_address_AddAddressComponent__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(84279);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _asset_editIcon_png__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(87207);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(58861);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _mui_icons_material_BorderColor__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(9237);
/* harmony import */ var _mui_icons_material_BorderColor__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_BorderColor__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var components_profile_VerifiedIcon__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(27653);
/* harmony import */ var _mui_icons_material_ReportProblem__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(54527);
/* harmony import */ var _mui_icons_material_ReportProblem__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_ReportProblem__WEBPACK_IMPORTED_MODULE_18__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_BasicInformationForm__WEBPACK_IMPORTED_MODULE_5__, _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_7__, _AccountInformation__WEBPACK_IMPORTED_MODULE_8__, _address_add_new_address_AddAddressComponent__WEBPACK_IMPORTED_MODULE_11__]);
([_BasicInformationForm__WEBPACK_IMPORTED_MODULE_5__, _alert_CustomAlert__WEBPACK_IMPORTED_MODULE_7__, _AccountInformation__WEBPACK_IMPORTED_MODULE_8__, _address_add_new_address_AddAddressComponent__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



















const SmallDeviceIconButton = (0,_mui_system__WEBPACK_IMPORTED_MODULE_6__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_4__.IconButton)(({ theme  })=>({
        border: "1px solid",
        borderColor: theme.palette.neutral[400],
        borderRadius: "50%",
        padding: "6px"
    }));
const BasicInformation = (props)=>{
    const { data , t , refetch , setEditProfile , editProfile , setAddAddress , addAddress , editAddress , addressRefetch , setEditAddress  } = props;
    const theme = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_15__.useTheme)();
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_12__.useSelector)((state)=>state.configData);
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_4__.useMediaQuery)(theme.breakpoints.down("md"));
    const handleClick = ()=>{
        setEditProfile((prvState)=>!prvState);
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
            container: true,
            spacing: {
                xs: 1,
                sm: 2,
                md: 3
            },
            padding: {
                xs: "10px",
                sm: "15px",
                md: "20px"
            },
            children: addAddress ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                container: true,
                item: true,
                xs: 12,
                md: 12,
                spacing: 3,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_address_add_new_address_AddAddressComponent__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                    setAddAddress: setAddAddress,
                    configData: configData,
                    userData: data,
                    editAddress: editAddress,
                    addressRefetch: addressRefetch,
                    setEditAddress: setEditAddress
                })
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: editProfile ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                        container: true,
                        item: true,
                        xs: 12,
                        md: 12,
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_BasicInformationForm__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP, {
                            data: data,
                            configData: configData,
                            setEditProfile: setEditProfile,
                            handleClick: handleClick,
                            t: t,
                            refetch: refetch
                        })
                    })
                }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                            item: true,
                            md: 12,
                            xs: 12,
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Stack, {
                                direction: "row",
                                justifyContent: "space-between",
                                alignItems: "center",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                        fontSize: {
                                            xs: "14px",
                                            sm: "14px",
                                            md: "16px"
                                        },
                                        fontWeight: "700",
                                        children: t("Personal Details")
                                    }),
                                    isSmall && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(SmallDeviceIconButton, {
                                        onClick: handleClick,
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {
                                            src: _asset_editIcon_png__WEBPACK_IMPORTED_MODULE_13__/* ["default"].src */ .Z.src,
                                            height: "16px",
                                            width: "16px"
                                        })
                                    })
                                ]
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                            item: true,
                            xs: 12,
                            md: 3,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Stack, {
                                spacing: {
                                    xs: 1,
                                    sm: 1,
                                    md: 1
                                },
                                paddingLeft: {
                                    xs: "0px",
                                    md: "20px"
                                },
                                children: data ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                    children: [
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                            fontWeight: "500",
                                            fontSize: {
                                                xs: "12px",
                                                md: "14px"
                                            },
                                            children: [
                                                t("User Name"),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                                    component: "span",
                                                    marginLeft: {
                                                        xs: "13px",
                                                        md: "10px"
                                                    },
                                                    fontSize: {
                                                        xs: "12px",
                                                        md: "14px"
                                                    },
                                                    children: `${data?.f_name ? data?.f_name : ""} ${data?.l_name ? data?.l_name : ""}`
                                                })
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Box, {
                                            display: "flex",
                                            alignItems: "center",
                                            fontWeight: "500",
                                            fontSize: {
                                                xs: "12px",
                                                md: "14px"
                                            },
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                                    component: "span",
                                                    fontSize: {
                                                        xs: "12px",
                                                        md: "14px"
                                                    },
                                                    children: t("Email")
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                                    fontSize: {
                                                        xs: "12px",
                                                        md: "14px"
                                                    },
                                                    component: "span",
                                                    marginLeft: {
                                                        xs: "8px",
                                                        md: "8px"
                                                    },
                                                    children: data?.email || ""
                                                }),
                                                data?.is_email_verified === 1 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_profile_VerifiedIcon__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                                    style: {
                                                        marginLeft: "8px"
                                                    }
                                                }) : configData?.centralize_login?.email_verification_status === 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_ReportProblem__WEBPACK_IMPORTED_MODULE_18___default()), {
                                                    sx: {
                                                        color: (theme)=>theme.palette.error.main,
                                                        width: "1.2rem",
                                                        marginLeft: "8px"
                                                    }
                                                })
                                            ]
                                        })
                                    ]
                                }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Stack, {
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Skeleton, {
                                            variant: "text",
                                            width: 150,
                                            height: 20
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Skeleton, {
                                            variant: "text",
                                            width: 150,
                                            height: 20
                                        })
                                    ]
                                })
                            })
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                            item: true,
                            xs: 12,
                            md: 3,
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Stack, {
                                spacing: {
                                    xs: 1,
                                    sm: 1,
                                    md: 1
                                },
                                alignItems: {
                                    xs: "flex-start",
                                    md: "center"
                                },
                                width: "100%",
                                justifyContent: "center",
                                children: data ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Box, {
                                    display: "flex",
                                    alignItems: "center",
                                    justifyContent: "center",
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                            fontWeight: "500",
                                            fontSize: {
                                                xs: "12px",
                                                md: "14px"
                                            },
                                            children: t("Phone")
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Typography, {
                                            component: "span",
                                            fontSize: {
                                                xs: "12px",
                                                md: "14px"
                                            },
                                            marginLeft: {
                                                xs: "8px",
                                                md: "10px"
                                            },
                                            display: "flex",
                                            alignItems: "center",
                                            children: [
                                                data?.phone,
                                                data?.is_phone_verified === 1 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_profile_VerifiedIcon__WEBPACK_IMPORTED_MODULE_17__/* ["default"] */ .Z, {
                                                    style: {
                                                        marginLeft: "8px"
                                                    }
                                                }) : configData?.centralize_login?.phone_verification_status === 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_ReportProblem__WEBPACK_IMPORTED_MODULE_18___default()), {
                                                    sx: {
                                                        color: (theme)=>theme.palette.error.main,
                                                        width: "1.2rem",
                                                        marginLeft: "8px"
                                                    }
                                                })
                                            ]
                                        })
                                    ]
                                }) : /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_6__.Stack, {
                                    children: [
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Skeleton, {
                                            variant: "text",
                                            width: 170,
                                            height: 20
                                        }),
                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Skeleton, {
                                            variant: "text",
                                            width: 170,
                                            height: 20
                                        })
                                    ]
                                })
                            })
                        }),
                        !isSmall && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Grid, {
                            item: true,
                            xs: 6,
                            md: 6,
                            align: "right",
                            alignSelf: "flex-start",
                            marginTop: {
                                xs: "5px",
                                md: "0px"
                            },
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_4__.Button, {
                                onClick: handleClick,
                                variant: "contained",
                                sx: {
                                    fontSize: "12px",
                                    borderRadius: "5px"
                                },
                                startIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_BorderColor__WEBPACK_IMPORTED_MODULE_16___default()), {
                                    style: {
                                        width: "13px",
                                        height: "13px"
                                    }
                                }),
                                children: t("Edit Profile")
                            })
                        })
                    ]
                })
            })
        })
    });
};
BasicInformation.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BasicInformation);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;